/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiNpcPngAnimation;
import org.lwjgl.opengl.GL11;

public class GuiNpcUtil {
    private static final Map<ResourceLocation, GuiNpcPngAnimation> itemsMap = new HashMap<ResourceLocation, GuiNpcPngAnimation>();
    private static final Map<ResourceLocation, GuiNpcPngAnimation> entitysMap = new HashMap<ResourceLocation, GuiNpcPngAnimation>();
    private static final List<ResourceLocation> notAnimated = new ArrayList<ResourceLocation>();

    public static void drawTexturedModalRect(ResourceLocation textureLocation, int textureU, int textureV, int textureWidth, int textureHeight, float scaleSize) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
        int addV = 0;
        int drawHeight = textureHeight;
        if (!notAnimated.contains(textureLocation)) {
            if (!itemsMap.containsKey(textureLocation)) {
                GuiNpcUtil.load(textureLocation, true);
            }
            if (itemsMap.containsKey(textureLocation)) {
                float wight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                float height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                float frame = itemsMap.get(textureLocation).getFrameId();
                float scale = height / wight;
                drawHeight = (int)(scaleSize / scale);
                addV = (int)(frame * (float)drawHeight);
                GlStateManager.func_179152_a((float)1.0f, (float)scale, (float)1.0f);
            }
        }
        GuiNpcUtil.drawTexturedModalRect(0, 0, textureU, textureV + addV, textureWidth, drawHeight);
    }

    public static void load(ResourceLocation textureLocation, boolean isItem) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            IResource res = mc.func_110442_L().func_110536_a(new ResourceLocation(textureLocation.func_110624_b(), textureLocation.func_110623_a() + ".mcmeta"));
            try (InputStreamReader reader = new InputStreamReader(res.func_110527_b(), StandardCharsets.UTF_8);){
                JsonParser parser = new JsonParser();
                JsonElement json = parser.parse((Reader)reader);
                if (json != null && json.getAsJsonObject().getAsJsonObject("animation") != null) {
                    JsonObject animation = json.getAsJsonObject().getAsJsonObject("animation");
                    mc.func_110434_K().func_110577_a(textureLocation);
                    GuiNpcPngAnimation pngAnimation = new GuiNpcPngAnimation(GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096), GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097), GL11.glGetInteger((int)32873), animation);
                    if (isItem) {
                        itemsMap.put(textureLocation, pngAnimation);
                    } else {
                        pngAnimation.createEntityIDs();
                        entitysMap.put(textureLocation, pngAnimation);
                    }
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!notAnimated.contains(textureLocation)) {
            notAnimated.add(textureLocation);
        }
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) * f), (double)((float)textureY * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindEntityTexture(TextureManager renderEngine, ResourceLocation textureLocation) {
        renderEngine.func_110577_a(textureLocation);
        if (!notAnimated.contains(textureLocation)) {
            if (!entitysMap.containsKey(textureLocation)) {
                GuiNpcUtil.load(textureLocation, false);
            }
            if (entitysMap.containsKey(textureLocation)) {
                GlStateManager.func_179144_i((int)entitysMap.get(textureLocation).getFrameEntityId());
            }
        }
    }
}

